//===========================================================
// Statbar.h - Include file for status bar lib file
// Copyright 1994 Douglas Boling
// Copyright (C) 1995 Ziff-Davis Publishing Company
//
//===========================================================

#define IDD_STATBAR            10000
#define IDM_SYSMENUACTIVE      10001
#define MENUTEXT               1000

#define SBITEMMAX              32

//Needed for Win 3.0 compile.
#ifndef COLOR_BTNHIGHLIGHT
#define COLOR_BTNHIGHLIGHT     4
#endif
// Status bar error messages
#define STERR_NOMEMORY         -1
#define STERR_TOOWIDE          -2
#define STERR_NOWNDCREATE      -3

//
// Structure used for StatusBarCreateEx
//
typedef struct {
	INT sWidth;
	UINT fFlags;
	DWORD dwData;
	LPSTR pText;
} SBITEM;

typedef struct {
	HFONT hFont;
	INT sFields;
	SBITEM sbi[SBITEMMAX];
} SBCREATESTRUCT;
//
// Types of controls available on the bar
//
#define FLAG_TYPEMASK      0x000F
#define STATT_BUTTON       0x0001
#define STATT_DCLKBUTTON   0x0002
#define STATT_MENU         0x0003
#define STATT_DYNAMENU     0x0004

#define STATN_CLICKED      0x0001
#define STATN_CREATEMENU   0x0002
#define STATN_DESTROYMENU  0x0003
#define STATN_PICKMENU     0x0004

#define MENU_USERDEF       0x0001
#define MENU_WINDOWS       0x0002

//
// Control messages
//
#define STATM_GETEVENTDATA WM_USER + 10
#define STATM_GETITEMDATA  WM_USER + 11
#define STATM_POSTEVENT    WM_USER + 12

//
// Flags defining the boxes on the bar
//
#define FLAG_DNORM         0x0000
#define FLAG_DIN           0x0080
#define FLAG_DOUT          0x0010
#define FLAG_DFLAT         0x0020
#define FLAG_DIN2          0x0040
#define FLAG_ICON          0x0100
//
//Public procedure declarations
//
INT StatusBarInit(HANDLE);
INT StatusBarTerm(HANDLE);
INT StatusBarCreate (HWND, INT, INT *);
INT StatusBarCreateEx (HWND, SBCREATESTRUCT *);
INT ModifyClientRect (HWND, RECT *);
INT SetStatusBarText (HWND, LPSTR, INT);
INT SetStatusBarLong (HWND, LPSTR, LONG, INT);
INT GetStatusBarHeight (HWND);

void Draw3DRect (HDC, HPEN, HPEN, RECT far *, UINT);
INT ComputeItemHeight (HWND, INT);

