//===========================================================
// WinBar.H -- Header File 
//
// Copyright (C) 1995 Ziff-Davis Publishing Company
// First published in PC Magazine by Douglas Boling
//
//===========================================================
// Returns no. of elements
#define dim(x) (sizeof(x) / sizeof(x[0]))   

#define  CMDSTACKSIZE      4096
//-----------------------------------------------------------
// Generic defines and data types
//-----------------------------------------------------------
#define INT       int
#define APIENTRY  PASCAL

#define MYMSG_CREATEBAR     WM_USER + 100
#define MYMSG_LAUNCHPROG    WM_USER + 101
#define MYMSG_SHELLNOTIFY   WM_USER + 102
#define MYMSG_SHELLACTIVATE WM_USER + 103
#define MYMSG_CMDLINECMD    WM_USER + 104

//
// Error numbers
//
#define ERR_LAUNCH         16
#define ERR_DOS            63
#define ERR_STATBAR        255

#define ERR_NOMENUNAME     1
#define ERR_EMPTYSUMMENU   2
#define ERR_NOCPLSPECIFIED 3
#define ERR_NOINTSPECIFIED 4
#define ERR_NOCMDSPECIFIED 5
#define ERR_LISTFULL       6
#define ERR_NOMEMORY       7
#define ERR_DISKFULL       8
#define ERR_BADFILE        9
#define ERR_CANCELED       10
#define ERR_BADCLIPSET     11
#define ERR_BADCLIPREAD    12
#define ERR_BADBARSEG      13

#define ERR_DOSFILENOFND   ERR_DOS + 2
#define TIPSTART           1024

struct decodeUINT {                         // structure associates
    UINT Code;                              // messages 
    LONG (*Fxn)(HWND, UINT, UINT, LONG);    // with a function
}; 
struct decodeCMD {                          // structure associates
    UINT Code;                              // menu IDs with a 
    LONG (*Fxn)(HWND, UINT, HWND, UINT);    // function
};
// Status flags
#define FLAG_SAVEONEXIT    0x0001
#define FLAG_ASKONEXIT     0x0002
#define FLAG_SHELL         0x0004
#define FLAG_SHUTDOWN      0x0008
#define FLAG_FASTMENU      0x0010
#define FLAG_ALWAYSONTOP   0x0020
#define FLAG_NOASKTHISEX   0x0040

#define MTYPE_CPL          0x0010
#define MTYPE_PROG         0x0020
#define MTYPE_SUBMENU      0x0030
#define MTYPE_WINLIST      0x0040
#define MTYPE_WINITEM      0x0050
#define MTYPE_INTERNAL     0x0060
#define MTYPE_SEP          0x0070
#define MTYPE_BARITEM      0x0080
#define MTYPE_FONTDATA     0x0090
#define MTYPE_FIELD        0x00a0

#define DISP_TEXT          0x0100
#define DISP_ICON          0x0200
#define DISP_TIME          0x0300
#define DISP_DATE          0x0400
#define DISP_NULL          0x0500
#define DISP_MAINSEP       0x0600
#define DISP_FMEM          0x0700
#define DISP_FRES          0x0800
#define DISP_FKRNL         0x0900
#define DISP_FUSER         0x0a00
#define DISP_FGDI          0x0b00

#define ITEM_TIME          0x0100
#define ITEM_DATE          0x0200

#define SWITCH_CHAR        '$'

typedef struct {
	INT sType;
	LOGFONT fm;
} FONTDATA;
typedef FONTDATA far *LPFONTDATA;

typedef struct {
	INT sMode;
	LPARAM lParam;
} EDITITEM;
typedef EDITITEM far *LPEDITITEM;

typedef struct {
	INT sType;
	INT sDisplayMode;
	char szIconFName[128];
	UINT wIconIndex;
} BARITEMDATA;
typedef BARITEMDATA far *LPBARITEMDATA;

typedef struct {
	INT sType;
	char szCmd[128];
	char szDir[128];
	char szIconFName[128];
	UINT wIconIndex;
	UINT wHotKey;
	UINT wStartFlags;
} GITEMDATA;
typedef GITEMDATA far *LPGITEMDATA;

typedef struct {
	INT sType;
	HGLOBAL hGlobal;
} SUBMENUDATA;
typedef SUBMENUDATA far *LPSUBMENUDATA;

typedef struct {
	INT sType;
	char szCmd[128];
} CPLITEMDATA;
typedef CPLITEMDATA far *LPCPLITEMDATA;

typedef struct {
	INT sType;
	HWND hWnd;
} WINITEMDATA;
typedef WINITEMDATA far *LPWINITEMDATA;

typedef struct {
	INT sType;
	UINT wID;
} INTITEMDATA;
typedef INTITEMDATA far *LPINTITEMDATA;

typedef struct {
	INT sType;
} SEPDATA;
typedef SEPDATA far *LPSEPDATA;

//
// Structures used to parse the Program Manager's group files
//
typedef struct {
    char  cIdentifier[4];
    WORD  wCheckSum;
    WORD  cbGroup;
    WORD  nCmdShow;
    RECT  rcNormal;
    POINT ptMin;
    WORD  pName;
    WORD  wLogPixelsX;
    WORD  wLogPixelsY;
    BYTE  bBitsPerPixel;
    BYTE  bPlanes;
    WORD  Reserved;
    WORD  cItems;
    WORD  rgiItems[];
} GROUPHEADER;
typedef GROUPHEADER far *LPGROUPHEADER;

typedef struct {
    POINT pt;
    WORD  iIcon;
    WORD  cbResource;
    WORD  cbANDPlane;
    WORD  cbXORPlane;
    WORD  pHeader;
    WORD  pANDPlane;
    WORD  pXORPlane;
    WORD  pName;
    WORD  pCommand;
    WORD  pIconPath;
} ITEMDATA;
typedef ITEMDATA far *LPITEMDATA;

typedef struct {
    WORD wID;           // Specifies the type of data in the structure
    WORD wItem;         // Specifies what program item the tag refers.
    WORD cb;            // Specifies the size of the tag data
    BYTE rgb[1];        // Start of data for this tag
} TAGDATA;
typedef TAGDATA far *LPTAGDATA;

//#define 0x8000 // - First tag structure in the list
//#define 0x8101 // - Tag contains the path for the program
//#define 0x8102 // - Tag contains the hot key for the program 
//#define 0x8103 // - Specifies that the program should be started minimized.
//#define 0xFFFF // - Indicates last tag structure in the list.

typedef struct tagICONPROPS { /* ip */

    unsigned reserved:12,   /* reserved                         */
             fResponse:1,   /* always 1                         */
             fRelease:1,    /* 1 if app. frees object, else 0   */
             reserved1:1,   /* reserved                         */
             fAckReq:1;     /* 1 if app. should respond, else 0 */
    int      cfFormat;      /* clipboard format (not used)      */
    int      nWidth;        /* width, in pixels, of the icon    */
    int      nHeight;       /* height, in pixels, of the icon   */
    BYTE     nPlanes;       /* number of planes in XOR mask     */

    BYTE     nBitsPixel;    /* number of bits/pixel in XOR mask */
    LPBYTE   lpANDbits;     /* points to AND mask array         */
    LPBYTE   lpXORbits;     /* points to XOR mask array         */
} ICONPROPS;
typedef ICONPROPS far *LPICONPROPS;

//
// Function prototypes used by generic template
//
INT  APIENTRY WinMain(HINSTANCE, HINSTANCE, LPSTR, INT);
LONG CALLBACK MainWndProc(HWND, UINT, UINT, LONG);
LONG CALLBACK LoadWndProc(HWND, UINT, UINT, LONG);
LONG CALLBACK HKeyFieldProc(HWND, UINT, UINT, LONG);
BOOL CALLBACK AboutDlgProc(HWND, UINT, UINT, LONG);

INT  InitApp(HANDLE);
INT  InitInstance(HANDLE, LPSTR, INT);
INT  TermInstance(HANDLE, INT);
INT  MyDisplayDialog (HINSTANCE, LPCSTR, HWND, DLGPROC, LPARAM);
void PrintError (HWND, INT);
BOOL MyGetFilename (HWND, char *, INT, char *, INT);
BOOL MyWritePrivateProfileInt (char *, char *, int, char *);
BOOL MyGetFont (HWND, LPLOGFONT, INT *, COLORREF *, DWORD);
BOOL MyYield (void);

// Dialog box functions
BOOL CALLBACK ConfigDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK RunDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK FindDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK EditItemDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK EditBarDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK HelpDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK SetIconDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK ListGroupDlgProc (HWND, UINT, UINT, LONG);
// Message handler functions
LONG DoCreateMain (HWND, UINT, UINT, LONG);
LONG DoCreateBarMain (HWND, UINT, UINT, LONG);
LONG DoLaunchProgMain (HWND, UINT, UINT, LONG);
LONG DoCmdLineCmdMain (HWND, UINT, UINT, LONG);
LONG DoShellNotifyMain (HWND, UINT, UINT, LONG);
LONG DoShellActivateMain (HWND, UINT, UINT, LONG);
LONG DoDDEWorkMain (HWND, UINT, UINT, LONG);
LONG DoActivateMain (HWND, UINT, UINT, LONG);
LONG DoNCCalcSizeMain (HWND, UINT, UINT, LONG);
LONG DoNCActivateMain (HWND, UINT, UINT, LONG);
LONG DoPaintMain (HWND, UINT, UINT, LONG);
LONG DoTimerMain (HWND, UINT, UINT, LONG);
LONG DoPaintMain (HWND, UINT, UINT, LONG);
LONG DoLaunchMain (HWND, UINT, UINT, LONG);
LONG DoDropFilesMain (HWND, UINT, UINT, LONG);
LONG DoCommandMain (HWND, UINT, UINT, LONG);
LONG DoMenuCharMain (HWND, UINT, UINT, LONG);
LONG DoDrawItemMain (HWND, UINT, UINT, LONG);
LONG DoMeasureItemMain (HWND, UINT, UINT, LONG);
LONG DoQEndSessionMain (HWND, UINT, UINT, LONG);
LONG DoCloseMain (HWND, UINT, UINT, LONG);
LONG DoDestroyMain (HWND, UINT, UINT, LONG);
// Control handlers
LONG DoMainMenuConfig (HWND, UINT, HWND, UINT);
LONG DoMainMenuEditStartup (HWND, UINT, HWND, UINT);
LONG DoMainMenuRun (HWND, UINT, HWND, UINT);
LONG DoMainMenuFind (HWND, UINT, HWND, UINT);
LONG DoMainMenuAbout (HWND, UINT, HWND, UINT);
LONG DoMainMenuWinExit (HWND, UINT, HWND, UINT);
LONG DoMainMenuExit (HWND, UINT, HWND, UINT);

void SavetoINI (HGLOBAL);
//
// Profile String Names
//
#define     PRO_XPOS      "WinPosX"
#define     PRO_YPOS      "WinPosY"
#define     PRO_XSIZE     "WinSizeX"
#define     PRO_YSIZE     "WinSizeY"

#define     PRO_MAINBAR     "WinBarItems"
#define     PRO_CNT         "ItemCnt"
#define     PRO_FLAGS       "Flags"
#define     PRO_CMD         "Cmd"
#define     PRO_DIR         "Dir"
#define     PRO_TYPE        "Type"
#define     PRO_BDISPMODE   "FieldType"
#define     PRO_BICONNAME   "BIconName"
#define     PRO_BICONINDEX  "BIconNum"
#define     PRO_ICONNAME    "IconName"
#define     PRO_ICONINDEX   "IconNum"
#define     PRO_HOTKEY      "HotKey"
#define     PRO_ID          "Identifier"

//
// Resource Idendifiers
//
#define     IDM_ABOUT      100
#define     IDM_CONFIG     101
#define     IDM_EXIT       102
#define     IDM_RUN        103
#define     IDM_EDITSTARTUP 104
#define     IDM_FIND       105
// Don't change any of these IDs above for backward compat!
#define     IDM_WINEXIT    106

// Configure dialog
#define     IDD_SETFONT    100
#define     IDD_PEDIT      101
#define     IDD_ILIBS      102
#define     IDD_ASKONEXIT  103
#define     IDD_SAVEONEXIT 104
#define     IDD_FASTMENU   105
#define     IDD_ONTOP      106
#define     IDD_MIGRATE    107
#define     IDD_SAVE       108

// Edit item dialog
#define     IDD_ITEMNAMET  100
#define     IDD_ITEMNAME   101
#define     IDD_TMENU      102
#define     IDD_TPROG      103
#define     IDD_TDOC       104
#define     IDD_TCPL       105
#define     IDD_TSPEC      106

#define     IDD_LISTT      110
#define     IDD_LIST       111
#define     IDD_ADD        112
#define     IDD_EDIT       113
#define     IDD_CUT        114
#define     IDD_COPY       115
#define     IDD_PASTE      116

#define     IDD_CMDT       120
#define     IDD_CMD        121
#define     IDD_WDIRT      122
#define     IDD_WDIR       123
#define     IDD_ACTIVATE   124
#define     IDD_HOTKEYT    125
#define     IDD_HOTKEY     126
#define     IDD_ICONPICT   127
#define     IDD_RFG        128
#define     IDD_RF1        129
#define     IDD_RF2        130
#define     IDD_RF3        131
#define     IDD_SETICON    132
#define     IDD_EDITBAT    133
#define     IDD_BROWSE     134
#define     IDD_ICONFNAME  135
#define     IDD_ICONINDEX  136

#define     IDD_DOCNAMET   140
#define     IDD_DOCNAME    141
#define     IDD_DOCTYPET   142
#define     IDD_DOCTYPE    143

#define     IDD_CPLTYPET   145
#define     IDD_CPLTYPE    146

#define     IDD_SPECTYPET  150
#define     IDD_SPECTYPE   151

#define     IDD_BTEXT      100
#define     IDD_BICON      101
#define     IDD_BSPEC      102

// Find dialog
#define     IDD_FIND       100
#define     IDD_MORE       101
#define     IDD_DOMAINT    102
#define     IDD_DOMAIN     103
#define     IDD_FILESPEC   104
#define     IDD_TEXTSPEC   105
#define     IDD_OUTLIST    106
#define     IDD_CONDITIONS 107
#define     IDD_RBTYPE     108
#define     IDD_RBSIZE     109
#define     IDD_RBDATE     110
#define     IDD_RBATTR     111
#define     IDD_PROPS      112

#define     IDD_TYPEA      120
#define     IDD_TYPESPECT  121
#define     IDD_TYPESPEC   122

#define     IDD_SIZEA      130
#define     IDD_SIZESPECT  131
#define     IDD_SIZESPEC   132
#define     IDD_SIZESPEC1  133

#define     IDD_DATEA      140
#define     IDD_DATESPECT  141
#define     IDD_DATESPEC   142
#define     IDD_DATESPEC1  143

#define     IDD_ATTRA      150
#define     IDD_ATTRRONLY  151
#define     IDD_ATTRARCH   152
#define     IDD_ATTRSYSTEM 153
#define     IDD_ATTRHIDDEN 154

// Edit bar item dialog
#define     IDD_BITEMNAMET 110
#define     IDD_BITEMNAME  111
#define     IDD_BICONBOX   121
#define     IDD_BICONPICT  122
#define     IDD_BSETICON   123
#define     IDD_BSPECTYPET 130
#define     IDD_BSPECTYPE  131
#define     IDD_BACTIONT   140
#define     IDD_BEDIT      141
#define     IDD_HELP       200
#define     IDD_HELPTEXT   210

// About box dialog
#define     IDD_PROGSTR    300
#define     IDD_FRAME      301
